local assets =
{
	Asset("ANIM", "anim/drop_cz83.zip"),
    Asset("ANIM", "anim/cz83.zip"), 
    Asset("ATLAS", "images/inventoryimages/cz83.xml"),
	Asset("IMAGE", "images/inventoryimages/cz83.tex")
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon("cz83.tex")

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("drop_cz83")
    inst.AnimState:SetBuild("drop_cz83")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "cz83"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/cz83.xml"
    inst:AddComponent("selfstacker")

    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("cz830", fn, assets)